function actn(obj,ca){
	/* ---- Public Variables ---- */
	this.actn_timeOut = -1; // Autocomplete Timeout in ms (-1: autocomplete never time out)
	this.actn_lim = 4;    // Number of elements autocomplete can show (-1: no limit)
	this.actn_firstText = false; // should the auto complete be limited to the beginning of keyword?
	this.actn_mouse = true; // Enable Mouse Support
	this.actn_delimiter = new Array(';',',');  // Delimiter for multiple autocomplete. Set it to empty array for single autocomplete
	this.actn_startcheck = 1; // Show widget only after this number of characters is typed in.
	/* ---- Public Variables ---- */

	/* --- Styles --- */
	this.actn_bgColor ='#DBD3FE';
	this.actn_textColor ='#000000';
	this.actn_hColor =  '#85A2C3';
	this.actn_fFamily = 'Verdana';
	this.actn_fSize = '11px';
	this.actn_hStyle = 'text-decoration:underline;font-weight="bold"';
	/* --- Styles --- */

	/* ---- Private Variables ---- */
	var actn_delimwords = new Array();
	var actn_cdelimword = 0;
	var actn_delimchar = new Array();
	var actn_display = false;
	var actn_pos = 0;
	var actn_total = 0;
	var actn_curr = null;
	var actn_rangeu = 0;
	var actn_ranged = 0;
	var actn_bool = new Array();
	var actn_pre = 0;
	var actn_toid;
	var actn_tomake = false;
	var actn_getpre = "";
	var actn_mouse_on_list = 1;
	var actn_kwcount = 0;
	var actn_caretmove = false;
	this.actn_keywords = new Array();
	/* ---- Private Variables---- */
	
	this.actn_keywords = ca;
	var actn_self = this;

	actn_curr = obj;
	
	addEvent(actn_curr,"focus",actn_setup);
	function actn_setup(){
		addEvent(document,"keydown",actn_checkkey);
		addEvent(actn_curr,"blur",actn_clear);
		addEvent(document,"keypress",actn_keypress);
	}

	function actn_clear(evt){
		if (!evt) evt = event;
		removeEvent(document,"keydown",actn_checkkey);
		removeEvent(actn_curr,"blur",actn_clear);
		removeEvent(document,"keypress",actn_keypress);
		actn_removedisp();
	}
	function actn_parse(n){
		if (actn_self.actn_delimiter.length > 0){
			var t = actn_delimwords[actn_cdelimword].trim().addslashes();
			var plen = actn_delimwords[actn_cdelimword].trim().length;
		}else{
			var t = actn_curr.value.addslashes();
			var plen = actn_curr.value.length;
		}
		var tobuild = '';
		var i;

		if (actn_self.actn_firstText){
			var re = new RegExp("^" + t, "i");
		}else{
			var re = new RegExp(t, "i");
		}
		var p = n.search(re);
				
		for (i=0;i<p;i++){
			tobuild += n.substr(i,1);
		}
		tobuild += "<font style='"+(actn_self.actn_hStyle)+"'>"
		for (i=p;i<plen+p;i++){
			tobuild += n.substr(i,1);
		}
		tobuild += "</font>";
			for (i=plen+p;i<n.length;i++){
			tobuild += n.substr(i,1);
		}
		return tobuild;
	}
	function actn_generate(){
		if (document.getElementById('tat_table')){ actn_display = false;document.body.removeChild(document.getElementById('tat_table')); } 
		if (actn_kwcount == 0){
			actn_display = false;
			return;
		}
		a = document.createElement('table');
		a.cellSpacing='1px';
		a.cellPadding='2px';
		a.style.position='absolute';
		a.style.top = eval(curTop(actn_curr) + actn_curr.offsetHeight) + "px";
		a.style.left = curLeft(actn_curr) + "px";
		a.style.backgroundColor=actn_self.actn_bgColor;
		a.id = 'tat_table';
		document.body.appendChild(a);
		var i;
		var first = true;
		var j = 1;
		if (actn_self.actn_mouse){
			a.onmouseout = actn_table_unfocus;
			a.onmouseover = actn_table_focus;
		}
		var counter = 0;
		for (i=0;i<actn_self.actn_keywords.length;i++){
			if (actn_bool[i]){
				counter++;
				r = a.insertRow(-1);
				if (first && !actn_tomake){
					r.style.backgroundColor = actn_self.actn_hColor;
					first = false;
					actn_pos = counter;
				}else if(actn_pre == i){
					r.style.backgroundColor = actn_self.actn_hColor;
					first = false;
					actn_pos = counter;
				}else{
					r.style.backgroundColor = actn_self.actn_bgColor;
				}
				r.id = 'tat_tr'+(j);
				c = r.insertCell(-1);
				c.style.color = actn_self.actn_textColor;
				c.style.fontFamily = actn_self.actn_fFamily;
				c.style.fontSize = actn_self.actn_fSize;
				c.innerHTML = actn_parse(actn_self.actn_keywords[i]);
				c.id = 'tat_td'+(j);
				c.setAttribute('pos',j);
				if (actn_self.actn_mouse){
					c.style.cursor = 'pointer';
					c.onclick=actn_mouseclick;
					c.onmouseover = actn_table_highlight;
				}
				j++;
			}
			if (j - 1 == actn_self.actn_lim && j < actn_total){
				r = a.insertRow(-1);
				r.style.backgroundColor = actn_self.actn_bgColor;
				c = r.insertCell(-1);
				c.style.color = actn_self.actn_textColor;
				c.style.fontFamily = 'arial narrow';
				c.style.fontSize = actn_self.actn_fSize;
				c.align='center';
				replaceHTML(c,'\\/');
				if (actn_self.actn_mouse){
					c.style.cursor = 'pointer';
					c.onclick = actn_mouse_down;
				}
				break;
			}
		}
		actn_rangeu = 1;
		actn_ranged = j-1;
		actn_display = true;
		if (actn_pos <= 0) actn_pos = 1;
	}
	function actn_remake(){
		document.body.removeChild(document.getElementById('tat_table'));
		a = document.createElement('table');
		a.cellSpacing='1px';
		a.cellPadding='2px';
		a.style.position='absolute';
		a.style.top = eval(curTop(actn_curr) + actn_curr.offsetHeight) + "px";
		a.style.left = curLeft(actn_curr) + "px";
		a.style.backgroundColor=actn_self.actn_bgColor;
		a.id = 'tat_table';
		if (actn_self.actn_mouse){
			a.onmouseout= actn_table_unfocus;
			a.onmouseover=actn_table_focus;
		}
		document.body.appendChild(a);
		var i;
		var first = true;
		var j = 1;
		if (actn_rangeu > 1){
			r = a.insertRow(-1);
			r.style.backgroundColor = actn_self.actn_bgColor;
			c = r.insertCell(-1);
			c.style.color = actn_self.actn_textColor;
			c.style.fontFamily = 'arial narrow';
			c.style.fontSize = actn_self.actn_fSize;
			c.align='center';
			replaceHTML(c,'/\\');
			if (actn_self.actn_mouse){
				c.style.cursor = 'pointer';
				c.onclick = actn_mouse_up;
			}
		}
		for (i=0;i<actn_self.actn_keywords.length;i++){
			if (actn_bool[i]){
				if (j >= actn_rangeu && j <= actn_ranged){
					r = a.insertRow(-1);
					r.style.backgroundColor = actn_self.actn_bgColor;
					r.id = 'tat_tr'+(j);
					c = r.insertCell(-1);
					c.style.color = actn_self.actn_textColor;
					c.style.fontFamily = actn_self.actn_fFamily;
					c.style.fontSize = actn_self.actn_fSize;
					c.innerHTML = actn_parse(actn_self.actn_keywords[i]);
					c.id = 'tat_td'+(j);
					c.setAttribute('pos',j);
					if (actn_self.actn_mouse){
						c.style.cursor = 'pointer';
						c.onclick=actn_mouseclick;
						c.onmouseover = actn_table_highlight;
					}
					j++;
				}else{
					j++;
				}
			}
			if (j > actn_ranged) break;
		}
		if (j-1 < actn_total){
			r = a.insertRow(-1);
			r.style.backgroundColor = actn_self.actn_bgColor;
			c = r.insertCell(-1);
			c.style.color = actn_self.actn_textColor;
			c.style.fontFamily = 'arial narrow';
			c.style.fontSize = actn_self.actn_fSize;
			c.align='center';
			replaceHTML(c,'\\/');
			if (actn_self.actn_mouse){
				c.style.cursor = 'pointer';
				c.onclick = actn_mouse_down;
			}
		}
	}
	function actn_goup(){
		if (!actn_display) return;
		if (actn_pos == 1) return;
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_bgColor;
		actn_pos--;
		if (actn_pos < actn_rangeu) actn_moveup();
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_hColor;
		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list=0;actn_removedisp();},actn_self.actn_timeOut);
	}
	function actn_godown(){
		if (!actn_display) return;
		if (actn_pos == actn_total) return;
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_bgColor;
		actn_pos++;
		if (actn_pos > actn_ranged) actn_movedown();
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_hColor;
		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list=0;actn_removedisp();},actn_self.actn_timeOut);
	}
	function actn_movedown(){
		actn_rangeu++;
		actn_ranged++;
		actn_remake();
	}
	function actn_moveup(){
		actn_rangeu--;
		actn_ranged--;
		actn_remake();
	}

	/* Mouse */
	function actn_mouse_down(){
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_bgColor;
		actn_pos++;
		actn_movedown();
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_hColor;
		actn_curr.focus();
		actn_mouse_on_list = 0;
		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list=0;actn_removedisp();},actn_self.actn_timeOut);
	}
	function actn_mouse_up(evt){
		if (!evt) evt = event;
		if (evt.stopPropagation){
			evt.stopPropagation();
		}else{
			evt.cancelBubble = true;
		}
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_bgColor;
		actn_pos--;
		actn_moveup();
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_hColor;
		actn_curr.focus();
		actn_mouse_on_list = 0;
		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list=0;actn_removedisp();},actn_self.actn_timeOut);
	}
	function actn_mouseclick(evt){
		if (!evt) evt = event;
		if (!actn_display) return;
		actn_mouse_on_list = 0;
		actn_pos = this.getAttribute('pos');
		actn_penter();
	}
	function actn_table_focus(){
		actn_mouse_on_list = 1;
	}
	function actn_table_unfocus(){
		actn_mouse_on_list = 0;
		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list = 0;actn_removedisp();},actn_self.actn_timeOut);
	}
	function actn_table_highlight(){
		actn_mouse_on_list = 1;
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_bgColor;
		actn_pos = this.getAttribute('pos');
		while (actn_pos < actn_rangeu) actn_moveup();
		while (actn_pos > actn_ranged) actn_movedown();
		document.getElementById('tat_tr'+actn_pos).style.backgroundColor = actn_self.actn_hColor;
		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list = 0;actn_removedisp();},actn_self.actn_timeOut);
	}
	/* ---- */

	function actn_insertword(a){
		if (actn_self.actn_delimiter.length > 0){
			str = '';
			l=0;
			for (i=0;i<actn_delimwords.length;i++){
				if (actn_cdelimword == i){
					prespace = postspace = '';
					gotbreak = false;
					for (j=0;j<actn_delimwords[i].length;++j){
						if (actn_delimwords[i].charAt(j) != ' '){
							gotbreak = true;
							break;
						}
						prespace += ' ';
					}
					for (j=actn_delimwords[i].length-1;j>=0;--j){
						if (actn_delimwords[i].charAt(j) != ' ') break;
						postspace += ' ';
					}
					str += prespace;
					str += a;
					l = str.length;
					if (gotbreak) str += postspace;
				}else{
					str += actn_delimwords[i];
				}
				if (i != actn_delimwords.length - 1){
					str += actn_delimchar[i];
				}
			}
			actn_curr.value = str;
			setCaret(actn_curr,l);
		}else{
			actn_curr.value = a;
		}
		actn_mouse_on_list = 0;
		actn_removedisp();
	}
	function actn_penter(){
		if (!actn_display) return;
		actn_display = false;
		var word = '';
		var c = 0;
		for (var i=0;i<=actn_self.actn_keywords.length;i++){
			if (actn_bool[i]) c++;
			if (c == actn_pos){
				word = actn_self.actn_keywords[i];
				break;
			}
		}
		actn_insertword(word);
		l = getCaretStart(actn_curr);
	}
	function actn_removedisp(){
		if (actn_mouse_on_list==0){
			actn_display = 0;
			if (document.getElementById('tat_table')){ document.body.removeChild(document.getElementById('tat_table')); }
			if (actn_toid) clearTimeout(actn_toid);
		}
	}
	function actn_keypress(e){
		if (actn_caretmove) stopEvent(e);
		return !actn_caretmove;
	}
	function actn_checkkey(evt){
		if (!evt) evt = event;
		a = evt.keyCode;
		caret_pos_start = getCaretStart(actn_curr);
		actn_caretmove = 0;
		switch (a){
			case 38:
				actn_goup();
				actn_caretmove = 1;
				return false;
				break;
			case 40:
				actn_godown();
				actn_caretmove = 1;
				return false;
				break;
			case 13: case 9:
				if (actn_display){
					actn_caretmove = 1;
					actn_penter();
					return false;
				}else{
					return true;
				}
				break;
			default:
				setTimeout(function(){actn_tocomplete(a)},50);
				break;
		}
	}

	function actn_tocomplete(kc){
		if (kc == 38 || kc == 40 || kc == 13) return;
		var i;
		if (actn_display){ 
			var word = 0;
			var c = 0;
			for (var i=0;i<=actn_self.actn_keywords.length;i++){
				if (actn_bool[i]) c++;
				if (c == actn_pos){
					word = i;
					break;
				}
			}
			actn_pre = word;
		}else{ actn_pre = -1};
		
		if (actn_curr.value == ''){
			actn_mouse_on_list = 0;
			actn_removedisp();
			return;
		}
		if (actn_self.actn_delimiter.length > 0){
			caret_pos_start = getCaretStart(actn_curr);
			caret_pos_end = getCaretEnd(actn_curr);
			
			delim_split = '';
			for (i=0;i<actn_self.actn_delimiter.length;i++){
				delim_split += actn_self.actn_delimiter[i];
			}
			delim_split = delim_split.addslashes();
			delim_split_rx = new RegExp("(["+delim_split+"])");
			c = 0;
			actn_delimwords = new Array();
			actn_delimwords[0] = '';
			for (i=0,j=actn_curr.value.length;i<actn_curr.value.length;i++,j--){
				if (actn_curr.value.substr(i,j).search(delim_split_rx) == 0){
					ma = actn_curr.value.substr(i,j).match(delim_split_rx);
					actn_delimchar[c] = ma[1];
					c++;
					actn_delimwords[c] = '';
				}else{
					actn_delimwords[c] += actn_curr.value.charAt(i);
				}
			}

			var l = 0;
			actn_cdelimword = -1;
			for (i=0;i<actn_delimwords.length;i++){
				if (caret_pos_end >= l && caret_pos_end <= l + actn_delimwords[i].length){
					actn_cdelimword = i;
				}
				l+=actn_delimwords[i].length + 1;
			}
			var ot = actn_delimwords[actn_cdelimword].trim(); 
			var t = actn_delimwords[actn_cdelimword].addslashes().trim();
		}else{
			var ot = actn_curr.value;
			var t = actn_curr.value.addslashes();
		}
		if (ot.length == 0){
			actn_mouse_on_list = 0;
			actn_removedisp();
		}
		if (ot.length < actn_self.actn_startcheck) return this;
		if (actn_self.actn_firstText){
			var re = new RegExp("^" + t, "i");
		}else{
			var re = new RegExp(t, "i");
		}

		actn_total = 0;
		actn_tomake = false;
		actn_kwcount = 0;
		for (i=0;i<actn_self.actn_keywords.length;i++){
			actn_bool[i] = false;
			if (re.test(actn_self.actn_keywords[i])){
				actn_total++;
				actn_bool[i] = true;
				actn_kwcount++;
				if (actn_pre == i) actn_tomake = true;
			}
		}

		if (actn_toid) clearTimeout(actn_toid);
		if (actn_self.actn_timeOut > 0) actn_toid = setTimeout(function(){actn_mouse_on_list = 0;actn_removedisp();},actn_self.actn_timeOut);
		actn_generate();
	}
	return this;
}